set sql_safe_updates=0;

-- Appointment

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_APPOINTMENT_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    sg.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRSTNAME,
    T1.lastName AS PARENT_LASTNAME,
    T2.studentFirstName AS FIRST_NAME,
    T2.studentLastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    enquiry T1 ON T1.id = sg.enquiryId
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    sg.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='ENQUIRY_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ENQUIRY_APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Enquiry Buzz Appointment',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Enquiry Buzz Appointment',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','THANK YOU FOR YOUR APPOINTMENT','<html>
<head>
    <title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
    <tr style="background-color:fff; height:120px;">
            <td align="center" style="margin:0px; padding:4px;"><img src="$recipientData[&quot;HEADER_URL&quot;]" height="80"></td>
            </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">$recipientData[&quot;ENQUIRY_CODE&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</span></span></p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Thank you for coming in to see us. Now that you are equipped with the information that you need the next step is application. Visit our website $recipientData[&quot;WEBSITE_URL&quot;] to apply now.</p>
           <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">We look forward to seeing you in the future!</p>
           <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Kind regards,<br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Thank you for coming in to see us. Now that you are equipped with the information that you need the next step is application. Visit our website $recipientData[&quot;WEBSITE_URL&quot;] to apply now. We look forward to seeing you in the future! Kind regards, $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]');


-- End Messaging for Lead APPOINTMENT Event

set sql_safe_updates=1;

